#version 330

layout(location = 0) in vec4 aPosition;
layout(location = 1) in vec3 aNormal;
layout(location = 2) in vec3 aValue;

out vec3 vNormal;
out vec3 vColor;

uniform mat4 uWorldToClip;
uniform bool uToggle;

void main()
{
    gl_Position = uWorldToClip * aPosition;
    vNormal = aNormal;
    if (uToggle)
    {
        vColor = 0.5f*(vec3(1.0f, 1.0f, 1.0f) + vNormal);
    }
    else
    {
        vColor = aValue;
    }
}
